/****************************************************************************\ 
 *** 
 *** File                  : dssimengine_accesspoint.cpp
 *** Description           : 
 *** This file implements all access point functions provided by the simulation

 *** engine. The access point functions are called when the application state 

 *** changes or when the background task is executed.
 *** 
 *** Generated by dSPACE Tools.
 *** (c) Copyright 2013, dSPACE GmbH. All rights reserved.
\****************************************************************************/

#if !defined(DSSIMENGINE_ACCESSPOINT_CPP_)
#  define    DSSIMENGINE_ACCESSPOINT_CPP_


/* -- Include directives. -- */
#  include "dssimengine_accesspoint.h"
#  include "rtosal_simengineap.h"
#  include "rtosal_task.h"
#  include <dsrtt.h>
#  include "dssimengine_api.h"
#  include "IOCode_Data.h"
#  include "dssimengine_accesspoint_CAN.h"
#  include "Utils/StateManager/StateManager_external.h"
#  include "BusManager_Bus_Configuration__1__10897_1.h"

#  if defined(EXTERN_C_DECL)
#    undef EXTERN_C_DECL
#  endif
#  if defined(__cplusplus)
#    define EXTERN_C_DECL extern "C"
#  else
#    define EXTERN_C_DECL extern
#  endif


/* -- Defines and directives in module scope. After include directives. -- */
#ifdef SIMENG_ENABLE_TEST_HOOKS
#include "dssimengine_testhooks.h"
#endif

#include "dssimengine_defines.h"

/* -- Variable declarations in module scope. -- */
UInt8 isFirstSimulation = 1;UInt32* pFuseActualStatus = 0;
UInt32* pFuseRestoreRequest = 0;
UInt8* pFailureSimulationClientConnected = 0;
UInt8* pFailureSimulationFailureConfigured = 0;
UInt8* pFailureSimulationFailureActivated = 0;
UInt16* pFailureSimulationSequenceCount = 0;
UInt8* pFailureSimulationRelaySwitching = 0;
UInt32* pXilApiEesPortActiveErrorSet = 0;
UInt32* pXilApiEesPortErrorActivated = 0;
UInt32* pXilApiEesPortErrorSwitching = 0;
UInt32* xilApiEesPortFlags = 0;
UInt32* xilApiEesPortTrigger = 0;

/* Suppress optimization since is not required for initialization code and */
/* may lead to compile problems in case of high global variable count */
#ifdef __GNUC__
#pragma GCC optimize ("O0")
#endif

/* -- Declarations of extern functions. -- */

 EXTERN_C_DECL void Thermal_system_2020_DSRTInitMdl(
    void);

 EXTERN_C_DECL void Thermal_system_2020_DSRTStartMdl(
    void);

 EXTERN_C_DECL void Thermal_system_2020_DSRTStopMdl(
    void);

/* -- Declarations of module local functions. -- */

  void ApSimEngineRunTimeInit(
    DsTErrorList ErrorList, Int32 calledOnStart);

/* -- Definitions of exported functions. -- */

  void
ApSimEngineOnInit(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitPreCompTestHook();
    ApSimEngineOnInitIoPreRtosInit(ErrorList);
    ApSimEngineOnInitRtos(ErrorList);
    ApSimEngineOnInitIoPostRtosInit(ErrorList);
    ApSimEngineOnInitImc(ErrorList);
    ApSimEngineOnInitMdl(ErrorList);
    ApSimEngineOnInitHwDiagnostics(ErrorList);
    ApSimEngineOnInitTestHook();

}

  void
ApSimEngineOnStart(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStartPreCompTestHook();
    ApSimEngineOnStartMdl(ErrorList);
    ApSimEngineOnStartIo(ErrorList);
    ApSimEngineOnStartImc(ErrorList);
    ApSimEngineOnStartRtos(ErrorList);
    ApSimEngineOnStartTestHook();

}

  void
ApSimEngineOnStop(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStopPreCompTestHook();
    ApSimEngineOnStopRtos(ErrorList);
    ApSimEngineOnStopImc(ErrorList);
    ApSimEngineOnStopIo(ErrorList);
    ApSimEngineOnStopMdl(ErrorList);
    ApSimEngineOnStopTestHook();

}

  void
ApSimEngineOnTerminate(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnTerminatePreCompTestHook();
    ApSimEngineOnTerminateMdl(ErrorList);
    ApSimEngineOnTerminateRtos(ErrorList);
    ApSimEngineOnTerminateImc(ErrorList);
    ApSimEngineOnTerminateIo(ErrorList);
    ApSimEngineOnTerminateTestHook();

}

  void
ApSimEngineOnUnload(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnUnloadPreCompTestHook();
    ApSimEngineOnUnloadRtos(ErrorList);
    ApSimEngineOnUnloadImc(ErrorList);
    ApSimEngineOnUnloadIo(ErrorList);
    ApSimEngineOnUnloadMdl(ErrorList);
    ApSimEngineOnUnloadTestHook();

}

  void
ApSimEngineOnInitMdl(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitMdlPreCompTestHook();
Thermal_system_2020_DSRTInitMdl();
    ApSimEngineOnInitMdlTestHook();

}

  void
ApSimEngineOnStartMdl(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStartMdlPreCompTestHook();
Thermal_system_2020_DSRTStartMdl();
    ApSimEngineOnStartMdlTestHook();

}

  void
ApSimEngineOnStopMdl(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStopMdlPreCompTestHook();
Thermal_system_2020_DSRTStopMdl();
    ApSimEngineOnStopMdlTestHook();

}

  void
ApSimEngineOnTerminateMdl(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnTerminateMdlPreCompTestHook();
    ApSimEngineOnTerminateMdlTestHook();

}

  void
ApSimEngineOnUnloadMdl(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnUnloadMdlPreCompTestHook();
    ApSimEngineOnUnloadMdlTestHook();

}

  void
ApSimEngineOnInitImc(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitImcPreCompTestHook();
    ApSimEngineOnInitImcTestHook();

}

  void
ApSimEngineOnStartImc(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStartImcPreCompTestHook();
    ApSimEngineOnStartImcTestHook();

}

  void
ApSimEngineOnStopImc(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStopImcPreCompTestHook();
    ApSimEngineOnStopImcTestHook();

}

  void
ApSimEngineOnTerminateImc(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnTerminateImcPreCompTestHook();
    ApSimEngineOnTerminateImcTestHook();

}

  void
ApSimEngineOnUnloadImc(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnUnloadImcPreCompTestHook();
    ApSimEngineOnUnloadImcTestHook();

}

  void
ApSimEngineOnInitIoPreRtosInit(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitIoPreRtosInitPreCompTestHook();
DsCApplication* pApp = SimEngineApplGet();
// Self assignment of pApp to prevent compiler warning in case of applications without function blocks
pApp = pApp;
/* Registration of resource table to enable FIU functionality */
pApp->setIoResourceMap(ErrorList, &g_ResourceMap);
    thermal_system_2020_fcnModule_SIDRoot_TID1 = DsCFcnModule::create(ErrorList, pApp);
ApSimEngineOnInitIoPreRtosInit_ctlcBODY_2_ThermalCAN_i1_(ErrorList, pApp);
    ApSimEngineOnInitIoPreRtosInitTestHook();

}

  void
ApSimEngineOnInitIoPostRtosInit(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitIoPostRtosInitPreCompTestHook();
ApSimEngineOnInitIoPostRtosInit_ctlcBODY_0_ThermalCAN_i1_(ErrorList);
bus_Configuration_1_I_traction_Value_MDL_SignalRef = &bus_Configuration_1_I_traction_Value_IO_Signal;
bus_Configuration_1_Q_charger_Value_MDL_SignalRef = &bus_Configuration_1_Q_charger_Value_IO_Signal;
bus_Configuration_1_Q_dcdc_Value_MDL_SignalRef = &bus_Configuration_1_Q_dcdc_Value_IO_Signal;
bus_Configuration_1_Q_inverter_Value_MDL_SignalRef = &bus_Configuration_1_Q_inverter_Value_IO_Signal;
bus_Configuration_1_Q_motor_Value_MDL_SignalRef = &bus_Configuration_1_Q_motor_Value_IO_Signal;
bus_Configuration_1_cmd_battery_pump_Value_MDL_SignalRef = &bus_Configuration_1_cmd_battery_pump_Value_IO_Signal;
bus_Configuration_1_cmd_chiller_bypass_Value_MDL_SignalRef = &bus_Configuration_1_cmd_chiller_bypass_Value_IO_Signal;
bus_Configuration_1_cmd_comp_Value_MDL_SignalRef = &bus_Configuration_1_cmd_comp_Value_IO_Signal;
bus_Configuration_1_cmd_fan_Value_MDL_SignalRef = &bus_Configuration_1_cmd_fan_Value_IO_Signal;
bus_Configuration_1_cmd_heater_Value_MDL_SignalRef = &bus_Configuration_1_cmd_heater_Value_IO_Signal;
bus_Configuration_1_cmd_motor_pump_Value_MDL_SignalRef = &bus_Configuration_1_cmd_motor_pump_Value_IO_Signal;
bus_Configuration_1_cmd_parallel_serial_Value_MDL_SignalRef = &bus_Configuration_1_cmd_parallel_serial_Value_IO_Signal;
bus_Configuration_1_cmd_rad_bypass_Value_MDL_SignalRef = &bus_Configuration_1_cmd_rad_bypass_Value_IO_Signal;
bus_Configuration_1_v_vehicle_Value_MDL_SignalRef = &bus_Configuration_1_v_vehicle_Value_IO_Signal;
bus_Configuration_1_AngVel_Compressor_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_AngVel_Compressor_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_AngVel_Compressor_Value_TA_Switchvalue = 0;
bus_Configuration_1_EPower_Compressor_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_EPower_Compressor_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_EPower_Compressor_Value_TA_Switchvalue = 0;
bus_Configuration_1_PJoule_battery_Value_MDL_SignalNoCast = 0;
bus_Configuration_1_PJoule_battery_Value_TA_Replacevalue = 0;
bus_Configuration_1_PJoule_battery_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_battery1_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_battery1_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_battery1_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_battery2_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_battery2_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_battery2_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_battery3_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_battery3_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_battery3_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_battery4_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_battery4_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_battery4_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_coolant_battery_in_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_coolant_battery_in_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_coolant_battery_in_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_coolant_inverter_out_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_coolant_inverter_out_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_coolant_inverter_out_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_inverter_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_inverter_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_inverter_Value_TA_Switchvalue = 0;
bus_Configuration_1_T_motor_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_T_motor_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_T_motor_Value_TA_Switchvalue = 0;
bus_Configuration_1_Torque_Compressor_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_Torque_Compressor_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_Torque_Compressor_Value_TA_Switchvalue = 0;
bus_Configuration_1_i_battery_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_i_battery_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_i_battery_Value_TA_Switchvalue = 0;
bus_Configuration_1_p_chiller_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_p_chiller_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_p_chiller_Value_TA_Switchvalue = 0;
bus_Configuration_1_p_cond_Value_MDL_SignalNoCast = 0.0;
bus_Configuration_1_p_cond_Value_TA_Replacevalue = 0.0;
bus_Configuration_1_p_cond_Value_TA_Switchvalue = 0;
StateManager_StateManagerInit();BM_BUS_CONFIGURATION__1__10897_1_Init();/* Call RunTimeInit access point */
ApSimEngineRunTimeInit(ErrorList, 0);
    ApSimEngineOnInitIoPostRtosInitTestHook();

}

  void
ApSimEngineOnInitHwDiagnostics(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitHwDiagnosticsPreCompTestHook();
    // Get application object
    DsCApplication* pAppl = SimEngineApplGet();
    DsTDiagBlock* pDiagnosticsBlock = pAppl->getDiagnosticBlock(ErrorList);
    DsTFailureSimulationBlock* pFailureSimulationBlock = pAppl->getFailureSimulationBlock(ErrorList);
pFuseActualStatus = &pDiagnosticsBlock->FuseActualStatus;
pFuseRestoreRequest = &pDiagnosticsBlock->FuseRestoreRequest;
pFailureSimulationClientConnected = &pFailureSimulationBlock->ClientConnected;
pFailureSimulationFailureConfigured = &pFailureSimulationBlock->FailureConfigured;
pFailureSimulationFailureActivated = &pFailureSimulationBlock->FailureActivated;
pFailureSimulationSequenceCount = &pFailureSimulationBlock->SequenceCount;
pFailureSimulationRelaySwitching = &pFailureSimulationBlock->RelaySwitching;
pXilApiEesPortActiveErrorSet = &pFailureSimulationBlock->ActiveErrorSet;
pXilApiEesPortErrorActivated = &pFailureSimulationBlock->ErrorActivated;
pXilApiEesPortErrorSwitching = &pFailureSimulationBlock->ErrorSwitching;
xilApiEesPortFlags = 0;
xilApiEesPortTrigger = 0;
    ApSimEngineOnInitHwDiagnosticsTestHook();

}

  void
ApSimEngineOnStartIo(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStartIoPreCompTestHook();
/* Call RunTimeInit access point */
if (isFirstSimulation)
{
isFirstSimulation = 0;
ApSimEngineRunTimeInit(ErrorList, 1);
}
BM_BUS_CONFIGURATION__1__10897_1_OnStart();    ApSimEngineOnStartIoTestHook();

}

  void
ApSimEngineOnStopIo(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStopIoPreCompTestHook();
BM_BUS_CONFIGURATION__1__10897_1_OnStop();    ApSimEngineOnStopIoTestHook();

}

  void
ApSimEngineOnTerminateIo(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnTerminateIoPreCompTestHook();
ApSimEngineOnTerminateIo_ctlcBODY_0_ThermalCAN_i1_(ErrorList);
    ApSimEngineOnTerminateIoTestHook();

}

  void
ApSimEngineOnUnloadIo(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnUnloadIoPreCompTestHook();
ApSimEngineOnUnloadIo_ctlcBODY_0_ThermalCAN_i1_(ErrorList);
    ApSimEngineOnUnloadIoTestHook();

}

  void
ApSimEngineOnInitRtos(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnInitRtosPreCompTestHook();

    // Call init function that creates and configures all tasks
    RtosAlOnInit(ErrorList);

    /* Set stepsize to sampletime of RTT-task */
    dsrtt_set_step_size(0.2);
    

    /* Provide pointer to RTT-task */
    dsrtt_set_rtt_task(pRtosAlPeriodic_Task_1);
    ApSimEngineOnInitRtosTestHook();

}

  void
ApSimEngineOnStartRtos(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStartRtosPreCompTestHook();

    // Call function that configures the startup behavior of periodic tasks
    RtosAlOnStart(ErrorList);
    ApSimEngineOnStartRtosTestHook();

}

  void
ApSimEngineOnStopRtos(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnStopRtosPreCompTestHook();
    ApSimEngineOnStopRtosTestHook();

}

  void
ApSimEngineOnTerminateRtos(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnTerminateRtosPreCompTestHook();
    ApSimEngineOnTerminateRtosTestHook();

}

  void
ApSimEngineOnUnloadRtos(
    DsTErrorList ErrorList) 
{
    ApSimEngineOnUnloadRtosPreCompTestHook();
    ApSimEngineOnUnloadRtosTestHook();

}

  void
ApSimEngineIdle(
    DsTErrorList ErrorList) 
{
    ApSimEngineIdlePreCompTestHook();
    ApSimEngineIdleTestHook();

}

/* -- Definitions of module local functions. -- */

  void
ApSimEngineRunTimeInit(
    DsTErrorList ErrorList, Int32 calledOnStart) 
{
if (calledOnStart)
{
}

}

#endif                                 /* DSSIMENGINE_ACCESSPOINT_CPP_ */
/* [EOF] */
